﻿using System;
using System.Collections.Generic;
using System.Text;

namespace KursBeispiele
{
    public class MultiControlItem
    {
        /// <summary>
        /// Erstellt eine neue Instanz eines MultiControlItems zur Verwendung in unserem
        /// Multicontrol Steuerelement
        /// </summary>
        /// <param name="text">Der zu anzuzeigende Text</param>
        /// <param name="key">Der zu verwendende ImageKey</param>
        public MultiControlItem(string text, string key)
        {
            _key = key;
            _text = text;
        }

        string _key;

        public string Key
        {
            get { return _key; }
            set { _key = value; if (ItemChanged != null) ItemChanged(this, new EventArgs()); }
        }

        string _text;

        public string Text
        {
            get { return _text; }
            set { _text = value; if (ItemChanged != null) ItemChanged(this, new EventArgs()); }
        }

        object tag;

        public object Tag
        {
            get { return tag; }
            set { tag = value; }
        }

        /// <summary>
        /// Ein eigenes Event von uns - gibt dem MultiControl an, dass dieses Item wieder gezeichnet werden sollte
        /// </summary>
        public event EventHandler ItemChanged;
    }
}
